/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.CoercionException;
import org.hibernate.type.descriptor.java.CoercionHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class FloatJavaType
extends AbstractClassJavaType<Float>
implements PrimitiveJavaType<Float> {
    public static final FloatJavaType INSTANCE = new FloatJavaType();
    private static final double LOG_BASE10OF2 = Math.log(2.0) / Math.log(10.0);

    public FloatJavaType() {
        super(Float.class);
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return indicators.getJdbcType(6);
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(Float value) {
        return value == null ? null : value.toString();
    }

    @Override
    public Float fromString(CharSequence string) {
        return Float.valueOf(string.toString());
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof Float;
    }

    @Override
    public <X> X unwrap(Float value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Float.class.isAssignableFrom(type) || type == Object.class) {
            return (X)value;
        }
        if (Double.class.isAssignableFrom(type)) {
            return (X)Double.valueOf(value.doubleValue());
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (X)Byte.valueOf(value.byteValue());
        }
        if (Short.class.isAssignableFrom(type)) {
            return (X)Short.valueOf(value.shortValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)Integer.valueOf(value.intValue());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.longValue());
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return (X)BigInteger.valueOf(value.longValue());
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (X)BigDecimal.valueOf(value.floatValue());
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Float wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return floatValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            return Float.valueOf(string);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        return switch (javaType.getTypeName()) {
            case "byte", "java.lang.Byte", "short", "java.lang.Short", "int", "java.lang.Integer", "long", "java.lang.Long", "java.math.BigInteger", "java.math.BigDecimal" -> true;
            default -> false;
        };
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Float.TYPE;
    }

    @Override
    public Class<Float[]> getArrayClass() {
        return Float[].class;
    }

    @Override
    public Class<?> getPrimitiveArrayClass() {
        return float[].class;
    }

    @Override
    public Float getDefaultValue() {
        return Float.valueOf(0.0f);
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return 14L;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        if (jdbcType.isFloat()) {
            return dialect.getFloatPrecision();
        }
        return Math.min(dialect.getDefaultDecimalPrecision(), (int)Math.ceil((double)dialect.getFloatPrecision() * LOG_BASE10OF2));
    }

    @Override
    public <X> Float coerce(X value, JavaType.CoercionContext coercionContext) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return floatValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        if (value instanceof String) {
            return CoercionHelper.coerceWrappingError(() -> Float.valueOf(Float.parseFloat((String)value)));
        }
        throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce value '%s' [%s] to Float", value, value.getClass().getName()));
    }
}

