/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics;

import edu.wpi.first.wpilibj.util.Color;

public class CIEColor {
    private double X;
    private double Y;
    private double Z;
    private double magnitude;
    private final double[] XYZtoRGB = new double[]{3.2404542, -1.5371385, -0.4985314, -0.969266, 1.8760108, 0.041556, 0.0556434, -0.2040259, 1.0572252};

    private static double CIERGB_f(double val) {
        return val > 0.0031308 ? 1.055 * Math.pow(val, 0.4166666666666667) - 0.055 : 12.92 * val;
    }

    private static double clamp(double x, double min, double max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    private Color ToRGB() {
        double _X = CIEColor.clamp(this.X / 100.0, 0.0, 1.0);
        double _Y = CIEColor.clamp(this.Y / 100.0, 0.0, 1.0);
        double _Z = CIEColor.clamp(this.Z / 100.0, 0.0, 1.0);
        double r = _X * this.XYZtoRGB[0] + _Y * this.XYZtoRGB[1] + _Z * this.XYZtoRGB[2];
        double g = _X * this.XYZtoRGB[3] + _Y * this.XYZtoRGB[4] + _Z * this.XYZtoRGB[5];
        double b = _X * this.XYZtoRGB[6] + _Y * this.XYZtoRGB[7] + _Z * this.XYZtoRGB[8];
        r = CIEColor.CIERGB_f(r);
        g = CIEColor.CIERGB_f(g);
        b = CIEColor.CIERGB_f(b);
        return new Color(r, g, b);
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public double getZ() {
        return this.Z;
    }

    public double getYx() {
        return this.X / this.magnitude;
    }

    public double getYy() {
        return this.Y / this.magnitude;
    }

    public CIEColor(double x, double y, double z) {
        this.X = x;
        this.Y = y;
        this.Z = z;
        this.magnitude = x + y + z;
    }
}

