/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark.config;

import com.revrobotics.jni.CANSparkJNI;
import com.revrobotics.spark.config.AbsoluteEncoderConfigAccessor;
import com.revrobotics.spark.config.AnalogSensorConfigAccessor;
import com.revrobotics.spark.config.ClosedLoopConfigAccessor;
import com.revrobotics.spark.config.EncoderConfigAccessor;
import com.revrobotics.spark.config.LimitSwitchConfigAccessor;
import com.revrobotics.spark.config.SignalsConfigAccessor;
import com.revrobotics.spark.config.SoftLimitConfigAccessor;
import com.revrobotics.spark.config.SparkBaseConfig;
import com.revrobotics.spark.config.SparkParameters;

public class SparkBaseConfigAccessor {
    private final long sparkHandle;
    public final AbsoluteEncoderConfigAccessor absoluteEncoder;
    public final AnalogSensorConfigAccessor analogSensor;
    public final EncoderConfigAccessor encoder;
    public final LimitSwitchConfigAccessor limitSwitch;
    public final ClosedLoopConfigAccessor closedLoop;
    public final SoftLimitConfigAccessor softLimit;
    public final SignalsConfigAccessor signals;

    protected SparkBaseConfigAccessor(long sparkHandle) {
        this.sparkHandle = sparkHandle;
        this.absoluteEncoder = new AbsoluteEncoderConfigAccessor(sparkHandle);
        this.analogSensor = new AnalogSensorConfigAccessor(sparkHandle);
        this.encoder = new EncoderConfigAccessor(sparkHandle);
        this.limitSwitch = new LimitSwitchConfigAccessor(sparkHandle);
        this.closedLoop = new ClosedLoopConfigAccessor(sparkHandle);
        this.softLimit = new SoftLimitConfigAccessor(sparkHandle);
        this.signals = new SignalsConfigAccessor(sparkHandle);
    }

    public SparkBaseConfig.IdleMode getIdleMode() {
        int value = CANSparkJNI.c_Spark_GetParameterUint32(this.sparkHandle, SparkParameters.kIdleMode.value);
        return SparkBaseConfig.IdleMode.fromId(value);
    }

    public boolean getInverted() {
        return CANSparkJNI.c_Spark_GetParameterBool(this.sparkHandle, SparkParameters.kInverted.value);
    }

    public int getSmartCurrentLimit() {
        return CANSparkJNI.c_Spark_GetParameterUint32(this.sparkHandle, SparkParameters.kSmartCurrentStallLimit.value);
    }

    public int getSmartCurrentFreeLimit() {
        return CANSparkJNI.c_Spark_GetParameterUint32(this.sparkHandle, SparkParameters.kSmartCurrentFreeLimit.value);
    }

    public int getSmartCurrentRPMLimit() {
        return CANSparkJNI.c_Spark_GetParameterUint32(this.sparkHandle, SparkParameters.kSmartCurrentConfig.value);
    }

    public double getSecondaryCurrentLimit() {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kCurrentChop.value);
    }

    public int getSecondaryCurrentLimitChopCycles() {
        return CANSparkJNI.c_Spark_GetParameterInt32(this.sparkHandle, SparkParameters.kCurrentChopCycles.value);
    }

    public double getOpenLoopRampRate() {
        double value = CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kOpenLoopRampRate.value);
        if (value == 0.0) {
            return value;
        }
        return 1.0 / value;
    }

    public double getClosedLoopRampRate() {
        double value = CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kClosedLoopRampRate.value);
        if (value == 0.0) {
            return value;
        }
        return 1.0 / value;
    }

    public double getVoltageCompensation() {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kCompensatedNominalVoltage.value);
    }

    public boolean getVoltageCompensationEnabled() {
        return CANSparkJNI.c_Spark_GetParameterUint32(this.sparkHandle, SparkParameters.kVoltageCompensationMode.value) != 0;
    }

    public int getFollowerModeLeaderId() {
        return CANSparkJNI.c_Spark_GetParameterUint32(this.sparkHandle, SparkParameters.kFollowerModeLeaderId.value);
    }

    public boolean getFollowerModeInverted() {
        return CANSparkJNI.c_Spark_GetParameterBool(this.sparkHandle, SparkParameters.kFollowerModeIsInverted.value);
    }
}

