/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

final class BufferingClientHttpResponseWrapper
implements ClientHttpResponse {
    private final ClientHttpResponse response;
    private volatile byte @Nullable [] body;

    BufferingClientHttpResponseWrapper(ClientHttpResponse response) {
        this.response = response;
    }

    @Override
    public HttpStatusCode getStatusCode() throws IOException {
        return this.response.getStatusCode();
    }

    @Override
    public String getStatusText() throws IOException {
        return this.response.getStatusText();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.response.getHeaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBody() throws IOException {
        byte[] body2 = this.body;
        if (body2 == null) {
            BufferingClientHttpResponseWrapper bufferingClientHttpResponseWrapper = this;
            synchronized (bufferingClientHttpResponseWrapper) {
                body2 = this.body;
                if (body2 == null) {
                    this.body = body2 = StreamUtils.copyToByteArray((InputStream)this.response.getBody());
                }
            }
        }
        return new ByteArrayInputStream(body2);
    }

    @Override
    public void close() {
        this.response.close();
    }
}

