/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.security;

import io.github.wimdeblauwe.htmx.spring.boot.security.HxLocationRedirectStrategy;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

public class HxLocationRedirectLogoutSuccessHandler
implements LogoutSuccessHandler {
    private final LogoutSuccessHandler delegate;

    public HxLocationRedirectLogoutSuccessHandler(String logoutSuccessUrl) {
        this(logoutSuccessUrl, false);
    }

    public HxLocationRedirectLogoutSuccessHandler(String logoutSuccessUrl, boolean alwaysUse) {
        this(logoutSuccessUrl, alwaysUse, new HxLocationRedirectStrategy());
    }

    public HxLocationRedirectLogoutSuccessHandler(String logoutSuccessUrl, RedirectStrategy redirectStrategy) {
        this(logoutSuccessUrl, false, redirectStrategy);
    }

    public HxLocationRedirectLogoutSuccessHandler(String logoutSuccessUrl, boolean alwaysUse, RedirectStrategy redirectStrategy) {
        SimpleUrlLogoutSuccessHandler handler = new SimpleUrlLogoutSuccessHandler();
        handler.setDefaultTargetUrl(logoutSuccessUrl);
        handler.setAlwaysUseDefaultTargetUrl(alwaysUse);
        handler.setRedirectStrategy(redirectStrategy);
        this.delegate = handler;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.delegate.onLogoutSuccess(request, response, authentication);
    }
}

