/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementAdapter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.Property;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class TypeDescriptor
implements Serializable {
    private static final Map<Class<?>, TypeDescriptor> commonTypesCache = new HashMap(32);
    private static final Class<?>[] CACHED_COMMON_TYPES;
    private final Class<?> type;
    private final ResolvableType resolvableType;
    private final AnnotatedElementSupplier annotatedElementSupplier;
    private volatile @Nullable AnnotatedElementAdapter annotatedElement;

    public TypeDescriptor(MethodParameter methodParameter) {
        this.resolvableType = ResolvableType.forMethodParameter(methodParameter);
        this.type = this.resolvableType.resolve(methodParameter.getNestedParameterType());
        this.annotatedElementSupplier = () -> AnnotatedElementAdapter.from(methodParameter.getParameterIndex() == -1 ? methodParameter.getMethodAnnotations() : methodParameter.getParameterAnnotations());
    }

    public TypeDescriptor(Field field) {
        this.resolvableType = ResolvableType.forField(field);
        this.type = this.resolvableType.resolve(field.getType());
        this.annotatedElementSupplier = () -> AnnotatedElementAdapter.from(field.getAnnotations());
    }

    public TypeDescriptor(Property property) {
        Assert.notNull((Object)property, "Property must not be null");
        this.resolvableType = ResolvableType.forMethodParameter(property.getMethodParameter());
        this.type = this.resolvableType.resolve(property.getType());
        this.annotatedElementSupplier = () -> AnnotatedElementAdapter.from(property.getAnnotations());
    }

    public TypeDescriptor(ResolvableType resolvableType, @Nullable Class<?> type, Annotation @Nullable [] annotations) {
        this.resolvableType = resolvableType;
        this.type = type != null ? type : resolvableType.toClass();
        this.annotatedElementSupplier = () -> AnnotatedElementAdapter.from(annotations);
    }

    public Class<?> getObjectType() {
        return ClassUtils.resolvePrimitiveIfNecessary(this.getType());
    }

    public Class<?> getType() {
        return this.type;
    }

    public ResolvableType getResolvableType() {
        return this.resolvableType;
    }

    public Object getSource() {
        return this.resolvableType.getSource();
    }

    public @Nullable TypeDescriptor nested(int nestingLevel) {
        ResolvableType nested = this.resolvableType;
        for (int i = 0; i < nestingLevel; ++i) {
            if (Object.class == nested.getType()) continue;
            nested = nested.getNested(2);
        }
        if (nested == ResolvableType.NONE) {
            return null;
        }
        return this.getRelatedIfResolvable(nested);
    }

    public TypeDescriptor narrow(@Nullable Object value) {
        if (value == null) {
            return this;
        }
        ResolvableType narrowed = ResolvableType.forType(value.getClass(), this.getResolvableType());
        return new TypeDescriptor(narrowed, value.getClass(), this.getAnnotations());
    }

    public @Nullable TypeDescriptor upcast(@Nullable Class<?> superType) {
        if (superType == null) {
            return null;
        }
        Assert.isAssignable(superType, this.getType());
        return new TypeDescriptor(this.getResolvableType().as(superType), superType, this.getAnnotations());
    }

    public String getName() {
        return ClassUtils.getQualifiedName(this.getType());
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    private AnnotatedElementAdapter getAnnotatedElement() {
        AnnotatedElementAdapter annotatedElement = this.annotatedElement;
        if (annotatedElement == null) {
            this.annotatedElement = annotatedElement = (AnnotatedElementAdapter)this.annotatedElementSupplier.get();
        }
        return annotatedElement;
    }

    public Annotation[] getAnnotations() {
        return this.getAnnotatedElement().getAnnotations();
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        AnnotatedElementAdapter annotatedElement = this.getAnnotatedElement();
        if (annotatedElement.isEmpty()) {
            return false;
        }
        return AnnotatedElementUtils.isAnnotated((AnnotatedElement)annotatedElement, annotationType);
    }

    public <T extends Annotation> @Nullable T getAnnotation(Class<T> annotationType) {
        AnnotatedElementAdapter annotatedElement = this.getAnnotatedElement();
        if (annotatedElement.isEmpty()) {
            return null;
        }
        return AnnotatedElementUtils.getMergedAnnotation(annotatedElement, annotationType);
    }

    public boolean isAssignableTo(TypeDescriptor typeDescriptor) {
        boolean typesAssignable = typeDescriptor.getObjectType().isAssignableFrom(this.getObjectType());
        if (!typesAssignable) {
            return false;
        }
        if (this.isArray() && typeDescriptor.isArray()) {
            return this.isNestedAssignable(this.getElementTypeDescriptor(), typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isCollection() && typeDescriptor.isCollection()) {
            return this.isNestedAssignable(this.getElementTypeDescriptor(), typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isMap() && typeDescriptor.isMap()) {
            return this.isNestedAssignable(this.getMapKeyTypeDescriptor(), typeDescriptor.getMapKeyTypeDescriptor()) && this.isNestedAssignable(this.getMapValueTypeDescriptor(), typeDescriptor.getMapValueTypeDescriptor());
        }
        return true;
    }

    private boolean isNestedAssignable(@Nullable TypeDescriptor nestedTypeDescriptor, @Nullable TypeDescriptor otherNestedTypeDescriptor) {
        return nestedTypeDescriptor == null || otherNestedTypeDescriptor == null || nestedTypeDescriptor.isAssignableTo(otherNestedTypeDescriptor);
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getType());
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public @Nullable TypeDescriptor getElementTypeDescriptor() {
        if (this.getResolvableType().isArray()) {
            return new TypeDescriptor(this.getResolvableType().getComponentType(), null, this.getAnnotations());
        }
        if (Stream.class.isAssignableFrom(this.getType())) {
            return this.getRelatedIfResolvable(this.getResolvableType().as(Stream.class).getGeneric(0));
        }
        return this.getRelatedIfResolvable(this.getResolvableType().asCollection().getGeneric(0));
    }

    public @Nullable TypeDescriptor elementTypeDescriptor(Object element) {
        return this.narrow(element, this.getElementTypeDescriptor());
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    public @Nullable TypeDescriptor getMapKeyTypeDescriptor() {
        Assert.state(this.isMap(), "Not a [java.util.Map]");
        return this.getRelatedIfResolvable(this.getResolvableType().asMap().getGeneric(0));
    }

    public @Nullable TypeDescriptor getMapKeyTypeDescriptor(Object mapKey) {
        return this.narrow(mapKey, this.getMapKeyTypeDescriptor());
    }

    public @Nullable TypeDescriptor getMapValueTypeDescriptor() {
        Assert.state(this.isMap(), "Not a [java.util.Map]");
        return this.getRelatedIfResolvable(this.getResolvableType().asMap().getGeneric(1));
    }

    public @Nullable TypeDescriptor getMapValueTypeDescriptor(@Nullable Object mapValue) {
        return this.narrow(mapValue, this.getMapValueTypeDescriptor());
    }

    private @Nullable TypeDescriptor getRelatedIfResolvable(ResolvableType type) {
        if (type.resolve() == null) {
            return null;
        }
        return new TypeDescriptor(type, null, this.getAnnotations());
    }

    private @Nullable TypeDescriptor narrow(@Nullable Object value, @Nullable TypeDescriptor typeDescriptor) {
        if (typeDescriptor != null) {
            return typeDescriptor.narrow(value);
        }
        if (value != null) {
            return this.narrow(value);
        }
        return null;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeDescriptor)) {
            return false;
        }
        TypeDescriptor otherDesc = (TypeDescriptor)other;
        if (this.getType() != otherDesc.getType()) {
            return false;
        }
        if (!this.annotationsMatch(otherDesc)) {
            return false;
        }
        return Arrays.equals(this.getResolvableType().getGenerics(), otherDesc.getResolvableType().getGenerics());
    }

    private boolean annotationsMatch(TypeDescriptor otherDesc) {
        Annotation[] otherAnns;
        Annotation[] anns = this.getAnnotations();
        if (anns == (otherAnns = otherDesc.getAnnotations())) {
            return true;
        }
        if (anns.length != otherAnns.length) {
            return false;
        }
        if (anns.length > 0) {
            for (int i = 0; i < anns.length; ++i) {
                if (this.annotationEquals(anns[i], otherAnns[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean annotationEquals(Annotation ann, Annotation otherAnn) {
        return ann == otherAnn || ann.getClass() == otherAnn.getClass() && ann.equals(otherAnn);
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Annotation ann : this.getAnnotations()) {
            builder.append('@').append(TypeDescriptor.getName(ann.annotationType())).append(' ');
        }
        builder.append(this.getResolvableType());
        return builder.toString();
    }

    @Contract(value="!null -> !null; null -> null")
    public static @Nullable TypeDescriptor forObject(@Nullable Object source) {
        return source != null ? TypeDescriptor.valueOf(source.getClass()) : null;
    }

    public static TypeDescriptor valueOf(@Nullable Class<?> type) {
        TypeDescriptor desc;
        if (type == null) {
            type = Object.class;
        }
        return (desc = commonTypesCache.get(type)) != null ? desc : new TypeDescriptor(ResolvableType.forClass(type), null, null);
    }

    public static TypeDescriptor collection(Class<?> collectionType, @Nullable TypeDescriptor elementTypeDescriptor) {
        Assert.notNull(collectionType, "Collection type must not be null");
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("Collection type must be a [java.util.Collection]");
        }
        ResolvableType element = elementTypeDescriptor != null ? elementTypeDescriptor.resolvableType : null;
        return new TypeDescriptor(ResolvableType.forClassWithGenerics(collectionType, element), null, null);
    }

    public static TypeDescriptor map(Class<?> mapType, @Nullable TypeDescriptor keyTypeDescriptor, @Nullable TypeDescriptor valueTypeDescriptor) {
        Assert.notNull(mapType, "Map type must not be null");
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("Map type must be a [java.util.Map]");
        }
        ResolvableType key = keyTypeDescriptor != null ? keyTypeDescriptor.resolvableType : null;
        ResolvableType value = valueTypeDescriptor != null ? valueTypeDescriptor.resolvableType : null;
        return new TypeDescriptor(ResolvableType.forClassWithGenerics(mapType, key, value), null, null);
    }

    @Contract(value="!null -> !null; null -> null")
    public static @Nullable TypeDescriptor array(@Nullable TypeDescriptor elementTypeDescriptor) {
        if (elementTypeDescriptor == null) {
            return null;
        }
        return new TypeDescriptor(ResolvableType.forArrayComponent(elementTypeDescriptor.resolvableType), null, elementTypeDescriptor.getAnnotations());
    }

    public static @Nullable TypeDescriptor nested(MethodParameter methodParameter, int nestingLevel) {
        if (methodParameter.getNestingLevel() != 1) {
            throw new IllegalArgumentException("MethodParameter nesting level must be 1: use the nestingLevel parameter to specify the desired nestingLevel for nested type traversal");
        }
        return new TypeDescriptor(methodParameter).nested(nestingLevel);
    }

    public static @Nullable TypeDescriptor nested(Field field, int nestingLevel) {
        return new TypeDescriptor(field).nested(nestingLevel);
    }

    public static @Nullable TypeDescriptor nested(Property property, int nestingLevel) {
        return new TypeDescriptor(property).nested(nestingLevel);
    }

    private static String getName(Class<?> clazz) {
        String canonicalName = clazz.getCanonicalName();
        return canonicalName != null ? canonicalName : clazz.getName();
    }

    static {
        for (Class<?> preCachedClass : CACHED_COMMON_TYPES = new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, String.class, Object.class}) {
            commonTypesCache.put(preCachedClass, TypeDescriptor.valueOf(preCachedClass));
        }
    }

    private static interface AnnotatedElementSupplier
    extends Supplier<AnnotatedElementAdapter>,
    Serializable {
    }
}

