/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.servohub;

import com.revrobotics.REVLibError;
import com.revrobotics.jni.CANServoHubJNI;
import com.revrobotics.jni.REVLibJNI;
import com.revrobotics.servohub.ServoChannel;
import com.revrobotics.servohub.ServoHubLowLevel;
import com.revrobotics.servohub.config.ServoHubConfig;
import com.revrobotics.servohub.config.ServoHubConfigAccessor;

public class ServoHub
extends ServoHubLowLevel {
    private ServoChannel[] servoChannels = new ServoChannel[6];
    public final ServoHubConfigAccessor configAccessor = new ServoHubConfigAccessor(this.servoHubHandle);

    public ServoHub(int deviceId) {
        super(deviceId);
        for (int i = 0; i < this.servoChannels.length; ++i) {
            this.servoChannels[i] = new ServoChannel(ServoChannel.ChannelId.fromInt(i), this);
        }
    }

    public REVLibError configure(ServoHubConfig config, ResetMode resetMode) {
        this.throwIfClosed();
        REVLibError status = REVLibError.fromInt(CANServoHubJNI.c_ServoHub_Configure(this.servoHubHandle, config.flatten(), resetMode == ResetMode.kResetSafeParameters));
        if (status != REVLibError.kOk) {
            throw new IllegalStateException(REVLibJNI.c_REVLib_ErrorFromCode(status.value));
        }
        return status;
    }

    public REVLibError configureAsync(ServoHubConfig config, ResetMode resetMode) {
        this.throwIfClosed();
        return REVLibError.fromInt(CANServoHubJNI.c_ServoHub_ConfigureAsync(this.servoHubHandle, config.flatten(), resetMode == ResetMode.kResetSafeParameters));
    }

    public boolean hasActiveFault() {
        this.throwIfClosed();
        return CANServoHubJNI.c_ServoHub_GetFaults(this.servoHubHandle) != 0;
    }

    public boolean hasStickyFault() {
        this.throwIfClosed();
        return CANServoHubJNI.c_ServoHub_GetStickyFaults(this.servoHubHandle) != 0;
    }

    public boolean hasActiveWarning() {
        this.throwIfClosed();
        return CANServoHubJNI.c_ServoHub_GetWarnings(this.servoHubHandle) != 0;
    }

    public boolean hasStickyWarning() {
        this.throwIfClosed();
        return CANServoHubJNI.c_ServoHub_GetStickyWarnings(this.servoHubHandle) != 0;
    }

    public Faults getFaults() {
        this.throwIfClosed();
        return new Faults(CANServoHubJNI.c_ServoHub_GetFaults(this.servoHubHandle));
    }

    public Faults getStickyFaults() {
        this.throwIfClosed();
        return new Faults(CANServoHubJNI.c_ServoHub_GetStickyFaults(this.servoHubHandle));
    }

    public Warnings getWarnings() {
        this.throwIfClosed();
        return new Warnings(CANServoHubJNI.c_ServoHub_GetWarnings(this.servoHubHandle));
    }

    public Warnings getStickyWarnings() {
        this.throwIfClosed();
        return new Warnings(CANServoHubJNI.c_ServoHub_GetStickyWarnings(this.servoHubHandle));
    }

    public REVLibError clearFaults() {
        this.throwIfClosed();
        return REVLibError.fromInt(CANServoHubJNI.c_ServoHub_ClearFaults(this.servoHubHandle));
    }

    public double getDeviceVoltage() {
        this.throwIfClosed();
        return CANServoHubJNI.c_ServoHub_GetDeviceVoltage(this.servoHubHandle);
    }

    public double getDeviceCurrent() {
        this.throwIfClosed();
        return CANServoHubJNI.c_ServoHub_GetDeviceCurrent(this.servoHubHandle);
    }

    public double getServoVoltage() {
        this.throwIfClosed();
        return CANServoHubJNI.c_ServoHub_GetServoVoltage(this.servoHubHandle);
    }

    public ServoChannel getServoChannel(ServoChannel.ChannelId channelId) {
        this.throwIfClosed();
        return this.servoChannels[channelId.value];
    }

    public REVLibError setBankPulsePeriod(Bank bank, int pulsePeriod_us) {
        this.throwIfClosed();
        return REVLibError.fromInt(CANServoHubJNI.c_ServoHub_SetBankPulsePeriod(this.servoHubHandle, bank.value, pulsePeriod_us));
    }

    public static enum ResetMode {
        kNoResetSafeParameters(0),
        kResetSafeParameters(1);

        public final int value;

        private ResetMode(int value) {
            this.value = value;
        }
    }

    public static class Faults {
        public final boolean regulatorPowerGood;
        public final boolean hardware;
        public final boolean firmware;
        public final boolean lowBattery;
        public final int rawBits;

        public Faults(int faults) {
            this.rawBits = faults;
            this.regulatorPowerGood = (faults & 1) != 0;
            this.hardware = (faults & 2) != 0;
            this.firmware = (faults & 4) != 0;
            this.lowBattery = (faults & 8) != 0;
        }
    }

    public static class Warnings {
        public final boolean brownout;
        public final boolean canWarning;
        public final boolean canBusOff;
        public final boolean hasReset;
        public final boolean channel0Overcurrent;
        public final boolean channel1Overcurrent;
        public final boolean channel2Overcurrent;
        public final boolean channel3Overcurrent;
        public final boolean channel4Overcurrent;
        public final boolean channel5Overcurrent;
        public final int rawBits;

        public Warnings(int warnings) {
            this.rawBits = warnings;
            this.brownout = (warnings & 1) != 0;
            this.canWarning = (warnings & 2) != 0;
            this.canBusOff = (warnings & 4) != 0;
            this.hasReset = (warnings & 8) != 0;
            this.channel0Overcurrent = (warnings & 0x10) != 0;
            this.channel1Overcurrent = (warnings & 0x20) != 0;
            this.channel2Overcurrent = (warnings & 0x40) != 0;
            this.channel3Overcurrent = (warnings & 0x80) != 0;
            this.channel4Overcurrent = (warnings & 0x100) != 0;
            this.channel5Overcurrent = (warnings & 0x200) != 0;
        }
    }

    public static enum Bank {
        kBank0_2(0),
        kBank3_5(1);

        public final int value;

        private Bank(int value) {
            this.value = value;
        }
    }
}

