/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark.config;

import com.revrobotics.jni.CANSparkJNI;
import com.revrobotics.spark.config.SparkParameters;

public class EncoderConfigAccessor {
    private final long sparkHandle;

    protected EncoderConfigAccessor(long sparkHandle) {
        this.sparkHandle = sparkHandle;
    }

    public int getCountsPerRevolution() {
        return CANSparkJNI.c_Spark_GetParameterUint32(this.sparkHandle, SparkParameters.kEncoderCountsPerRev.value);
    }

    public boolean getInverted() {
        return CANSparkJNI.c_Spark_GetParameterBool(this.sparkHandle, SparkParameters.kEncoderInverted.value);
    }

    public double getPositionConversionFactor() {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kPositionConversionFactor.value);
    }

    public double getVelocityConversionFactor() {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kVelocityConversionFactor.value);
    }

    public int getQuadratureAverageDepth() {
        return CANSparkJNI.c_Spark_GetParameterUint32(this.sparkHandle, SparkParameters.kEncoderAverageDepth.value);
    }

    public int getQuadratureMeasurementPeriod() {
        return CANSparkJNI.c_Spark_GetParameterUint32(this.sparkHandle, SparkParameters.kEncoderSampleDelta.value) >> 1;
    }

    public int getUvwAverageDepth() {
        int value = CANSparkJNI.c_Spark_GetParameterUint32(this.sparkHandle, SparkParameters.kUvwSensorAverageDepth.value);
        return 1 << value;
    }

    public int getUvwMeasurementPeriod() {
        float value = CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kUvwSensorSampleRate.value);
        return (int)(value * 1000.0f);
    }
}

