/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.transaction.jta.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJndi;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.transaction.autoconfigure.TransactionManagerCustomizers;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={JtaTransactionManager.class})
@ConditionalOnJndi(value={"java:comp/UserTransaction", "java:comp/TransactionManager", "java:appserver/TransactionManager", "java:pm/TransactionManager", "java:/TransactionManager"})
@ConditionalOnMissingBean(value={TransactionManager.class})
class JndiJtaConfiguration {
    JndiJtaConfiguration() {
    }

    @Bean
    JtaTransactionManager transactionManager(ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        JtaTransactionManager jtaTransactionManager = new JtaTransactionManager();
        transactionManagerCustomizers.ifAvailable(customizers -> customizers.customize((TransactionManager)jtaTransactionManager));
        return jtaTransactionManager;
    }
}

