/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class RuntimeJavadocHelper {
    public static final String INIT = "<init>";

    private RuntimeJavadocHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static <T> List<T> unmodifiableDefensiveCopy(List<T> list) {
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <T> T requireNonNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> items) {
        RuntimeJavadocHelper.requireNonNull(delimiter);
        StringBuilder result = new StringBuilder();
        Iterator<? extends CharSequence> i = items.iterator();
        while (i.hasNext()) {
            result.append(i.next());
            if (!i.hasNext()) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static List<Class<?>> getAllTypeAncestors(Class<?> clazz) {
        Class<?>[] interfaces;
        if (clazz == null) {
            return Collections.emptyList();
        }
        LinkedHashMap typeAncestors = new LinkedHashMap();
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            typeAncestors.put(superclass.getCanonicalName(), superclass);
            RuntimeJavadocHelper.getAllTypeAncestors(superclass).forEach(cls -> typeAncestors.put(cls.getCanonicalName(), (Class<?>)cls));
        }
        for (Class<?> superType : interfaces = clazz.getInterfaces()) {
            typeAncestors.put(superType.getCanonicalName(), superType);
            RuntimeJavadocHelper.getAllTypeAncestors(superType).forEach(cls -> typeAncestors.put(cls.getCanonicalName(), (Class<?>)cls));
        }
        return Collections.unmodifiableList(new ArrayList(typeAncestors.values()));
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static String javadocResourceSuffix() {
        return "__Javadoc.json";
    }

    public static String paramTypesFieldName() {
        return "paramTypes";
    }

    public static String fieldsFieldName() {
        return "fields";
    }

    public static String enumConstantsFieldName() {
        return "enumConstants";
    }

    public static String methodsFieldName() {
        return "methods";
    }

    public static String constructorsFieldName() {
        return "constructors";
    }

    public static String elementNameFieldName() {
        return "name";
    }

    public static String elementDocFieldName() {
        return "doc";
    }

    public static Method findBridgeMethod(Method method) {
        if (method.isBridge()) {
            return method;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        for (Method bridgeMethod : declaringClass.getDeclaredMethods()) {
            if (!bridgeMethod.isBridge() || !method.getName().equals(bridgeMethod.getName()) || !RuntimeJavadocHelper.parametersMatchWithErasure(method.getParameterTypes(), bridgeMethod.getParameterTypes())) continue;
            return bridgeMethod;
        }
        return null;
    }

    private static boolean parametersMatchWithErasure(Class<?>[] parameterTypes, Class<?>[] erasureTypes) {
        if (parameterTypes.length != erasureTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (erasureTypes[i].isAssignableFrom(parameterTypes[i])) continue;
            return false;
        }
        return true;
    }
}

