/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxSwapType;
import java.time.Duration;
import java.util.Objects;

public class HtmxReswap {
    private final HxSwapType type;
    private Duration swap;
    private Duration settle;
    private Position scroll;
    private String scrollTarget;
    private Position show;
    private String showTarget;
    private boolean transition;
    private Boolean focusScroll;

    public static HtmxReswap afterBegin() {
        return new HtmxReswap(HxSwapType.AFTER_BEGIN);
    }

    public static HtmxReswap afterEnd() {
        return new HtmxReswap(HxSwapType.AFTER_END);
    }

    public static HtmxReswap beforeBegin() {
        return new HtmxReswap(HxSwapType.BEFORE_BEGIN);
    }

    public static HtmxReswap beforeEnd() {
        return new HtmxReswap(HxSwapType.BEFORE_END);
    }

    public static HtmxReswap delete() {
        return new HtmxReswap(HxSwapType.DELETE);
    }

    public static HtmxReswap innerHtml() {
        return new HtmxReswap(HxSwapType.INNER_HTML);
    }

    public static HtmxReswap none() {
        return new HtmxReswap(HxSwapType.NONE);
    }

    public static HtmxReswap outerHtml() {
        return new HtmxReswap(HxSwapType.OUTER_HTML);
    }

    HtmxReswap(HxSwapType type) {
        this.type = type;
    }

    public Boolean getFocusScroll() {
        return this.focusScroll;
    }

    public Position getScroll() {
        return this.scroll;
    }

    public String getScrollTarget() {
        return this.scrollTarget;
    }

    public Duration getSettle() {
        return this.settle;
    }

    public Position getShow() {
        return this.show;
    }

    public String getShowTarget() {
        return this.showTarget;
    }

    public Duration getSwap() {
        return this.swap;
    }

    public HxSwapType getType() {
        return this.type;
    }

    public boolean isTransition() {
        return this.transition;
    }

    public String toHeaderValue() {
        StringBuilder value = new StringBuilder();
        value.append(this.type.getValue());
        if (this.transition) {
            value.append(" transition:true");
        }
        if (this.focusScroll != null) {
            value.append(" focus-scroll:").append(this.focusScroll);
        }
        if (this.swap != null) {
            value.append(" swap:").append(this.swap.toMillis()).append("ms");
        }
        if (this.settle != null) {
            value.append(" settle:").append(this.settle.toMillis()).append("ms");
        }
        if (this.scroll != null) {
            if (this.scrollTarget != null) {
                value.append(" scroll:").append(this.scrollTarget).append(":").append(this.scroll.getValue());
            } else {
                value.append(" scroll:").append(this.scroll.getValue());
            }
        }
        if (this.show != null) {
            if (this.showTarget != null) {
                value.append(" show:").append(this.showTarget).append(":").append(this.show.getValue());
            } else {
                value.append(" show:").append(this.show.getValue());
            }
        }
        return value.toString();
    }

    public HtmxReswap focusScroll(boolean enabled) {
        this.focusScroll = enabled;
        return this;
    }

    public HtmxReswap scroll(Position position) {
        this.scroll = position;
        return this;
    }

    public HtmxReswap scrollTarget(String cssSelector) {
        this.scrollTarget = cssSelector;
        return this;
    }

    public HtmxReswap settle(Duration duration) {
        this.settle = duration;
        return this;
    }

    public HtmxReswap show(Position position) {
        this.show = position;
        return this;
    }

    public HtmxReswap showTarget(String cssSelector) {
        this.showTarget = cssSelector;
        return this;
    }

    public HtmxReswap swap(Duration duration) {
        this.swap = duration;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HtmxReswap that = (HtmxReswap)object;
        return this.transition == that.transition && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.swap, that.swap) && Objects.equals(this.settle, that.settle) && this.scroll == that.scroll && Objects.equals(this.scrollTarget, that.scrollTarget) && this.show == that.show && Objects.equals(this.showTarget, that.showTarget) && Objects.equals(this.focusScroll, that.focusScroll);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.swap, this.settle, this.scroll, this.scrollTarget, this.show, this.showTarget, this.transition, this.focusScroll});
    }

    public String toString() {
        return this.toHeaderValue();
    }

    public HtmxReswap transition() {
        this.transition = true;
        return this;
    }

    public static enum Position {
        TOP("top"),
        BOTTOM("bottom");

        private final String value;

        private Position(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

