/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics;

import com.revrobotics.StatusFrameEmitter;
import com.revrobotics.devices.PneumaticHub;
import java.util.UUID;

public class PneumaticHubStatusEmitter
extends StatusFrameEmitter {
    private final PneumaticHub hub;
    private final StatusDataCallback statusDataCallback;
    private final String descriptor;
    private final UUID uuid;
    private final String messageName;

    public PneumaticHubStatusEmitter(String descriptor, UUID uuid, PneumaticHub hub, StatusDataCallback statusDataCallback, StatusFrameEmitter.OnStopCallback onStopCallback) {
        super(onStopCallback, 2);
        this.hub = hub;
        this.statusDataCallback = statusDataCallback;
        this.descriptor = descriptor;
        this.uuid = uuid;
        this.messageName = "Pneumatic Hub " + hub.getDeviceId();
    }

    private Status0 getStatus0(PneumaticHub hub) {
        PneumaticHub.Status0 frame = hub.getStatus0();
        if (frame == null) {
            return null;
        }
        return new Status0(frame.channel0On(), frame.channel1On(), frame.channel2On(), frame.channel3On(), frame.channel4On(), frame.channel5On(), frame.channel6On(), frame.channel7On(), frame.channel8On(), frame.channel9On(), frame.channel10On(), frame.channel11On(), frame.channel12On(), frame.channel13On(), frame.channel14On(), frame.channel15On(), frame.analogChannel0(), frame.analogChannel1(), frame.digitalSensor(), frame.brownoutFault(), frame.compressorOvercurrentFault(), frame.compressorOpenFault(), frame.solenoidOvercurrentFault(), frame.cANWarningFault(), frame.hardwareFault(), frame.channel0Fault(), frame.channel1Fault(), frame.channel2Fault(), frame.channel3Fault(), frame.channel4Fault(), frame.channel5Fault(), frame.channel6Fault(), frame.channel7Fault(), frame.channel8Fault(), frame.channel9Fault(), frame.channel10Fault(), frame.channel11Fault(), frame.channel12Fault(), frame.channel13Fault(), frame.channel14Fault(), frame.channel15Fault(), frame.compressorOn(), frame.systemEnabled(), frame.roborioPresent(), frame.compressorConfig());
    }

    private Status1 getStatus1(PneumaticHub hub) {
        PneumaticHub.Status1 frame = hub.getStatus1();
        if (frame == null) {
            return null;
        }
        return new Status1(frame.vBus(), frame.solenoidVoltage(), frame.compressorCurrent(), frame.solenoidCurrent(), frame.stickyBrownoutFault(), frame.stickyCompressorOCFault(), frame.stickyCompressorOpenFault(), frame.stickySolenoidOCFault(), frame.stickyCANWarningFault(), frame.stickyCANBusOffFault(), frame.stickyHardwareFault(), frame.stickyFirmwareFault(), frame.stickyHasReset(), frame.supplyVoltage5V());
    }

    @Override
    public void runFrameEmitter() {
        try {
            Status1 status1 = null;
            if (this.frameEnabled[1]) {
                status1 = this.getStatus1(this.hub);
            }
            Data data = new Data(this.getStatus0(this.hub), status1);
            PneumaticHubStatusData statusData = new PneumaticHubStatusData(this.getTimestamp(), this.messageName, this.descriptor, this.uuid, data);
            if (this.statusDataCallback != null) {
                this.statusDataCallback.statusDataCallback(statusData);
            }
        }
        catch (IllegalStateException e) {
            this.stop();
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Attempted to access invalid status frame. Check for programming error");
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getThreadName() {
        return "PowerHubStatusFrameEmitter(" + this.hub.getDeviceId() + ")";
    }

    public static interface StatusDataCallback {
        public void statusDataCallback(PneumaticHubStatusData var1);
    }

    public record Status0(boolean channel0On, boolean channel1On, boolean channel2On, boolean channel3On, boolean channel4On, boolean channel5On, boolean channel6On, boolean channel7On, boolean channel8On, boolean channel9On, boolean channel10On, boolean channel11On, boolean channel12On, boolean channel13On, boolean channel14On, boolean channel15On, double analogChannel0, double analogChannel1, boolean digitalSensor, boolean brownoutFault, boolean compressorOvercurrentFault, boolean compressorOpenFault, boolean solenoidOvercurrentFault, boolean canWarningFault, boolean hardwareFault, boolean channel0Fault, boolean channel1Fault, boolean channel2Fault, boolean channel3Fault, boolean channel4Fault, boolean channel5Fault, boolean channel6Fault, boolean channel7Fault, boolean channel8Fault, boolean channel9Fault, boolean channel10Fault, boolean channel11Fault, boolean channel12Fault, boolean channel13Fault, boolean channel14Fault, boolean channel15Fault, boolean compressorOn, boolean systemEnabled, boolean roborioPresent, int compressorConfig) {
    }

    public record Status1(double busVoltage, double solenoidVoltage, double compressorCurrent, double solenoidCurrent, boolean stickyBrownoutFault, boolean stickyCompressorOCFault, boolean stickyCompressorOpenFault, boolean stickySolenoidOCFault, boolean stickyCanWarningFault, boolean stickyCanBusOffFault, boolean stickyHardwareFault, boolean stickyFirmwareFault, boolean stickyHasReset, double supplyVoltage5V) {
    }

    public record Data(Status0 status0, Status1 status1) {
    }

    public record PneumaticHubStatusData(double timestamp, String name, String descriptor, UUID uuid, Data data) {
    }
}

