/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import com.revrobotics.canbridge.slcan.SLCanContext;
import com.revrobotics.revui.app.exceptions.InvalidModeException;
import com.revrobotics.revui.app.files.DirectoryManager;
import com.revrobotics.revui.app.ui.Window;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/settings"})
public class SettingsController {
    @PostMapping(value={"/tracing"})
    public static void setTracingEnabled(boolean enabled) {
        SLCanContext.setTracingEnabled((boolean)enabled);
    }

    @PostMapping(value={"/theme"})
    public void setTheme(Theme theme) {
        if (theme == null) {
            throw new InvalidModeException();
        }
        SettingsController.writeProperty("theme", theme.name());
        Window.getInstance().setIcon(theme == Theme.DARK ? Window.IconType.DARK : Window.IconType.LIGHT);
    }

    @GetMapping(value={"/theme"})
    public Theme getThemeEndpoint() {
        String themeString = SettingsController.getSettings().getProperty("theme");
        if (themeString == null) {
            return Theme.DEFAULT;
        }
        return Theme.valueOf(themeString);
    }

    private static Path getSettingsFilePath() {
        return DirectoryManager.getAppStoragePath().resolve("settings.properties");
    }

    private static Properties getSettings() {
        Path settingsFile = SettingsController.getSettingsFilePath();
        try {
            if (!Files.exists(settingsFile, new LinkOption[0])) {
                Files.createFile(settingsFile, new FileAttribute[0]);
            }
            Properties settings = new Properties();
            settings.load(Files.newInputStream(settingsFile, new OpenOption[0]));
            return settings;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeProperty(String key, String value) {
        Properties existing = SettingsController.getSettings();
        existing.put(key, value);
        try {
            existing.store(Files.newBufferedWriter(SettingsController.getSettingsFilePath(), new OpenOption[0]), "REVUI Settings");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Theme getTheme() {
        String themeString = SettingsController.getSettings().getProperty("theme");
        if (themeString == null) {
            return Theme.LIGHT;
        }
        return Theme.valueOf(themeString);
    }

    public static enum Theme {
        LIGHT,
        DARK,
        DEFAULT;

    }
}

