/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.devices;

import com.revrobotics.device.detection.DeviceDaemon;
import com.revrobotics.device.detection.device.DeviceTree;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.revui.app.CanBridgeController;
import com.revrobotics.revui.app.exceptions.CanBusNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/bus/{descriptor}/rev"})
public class REVDevicesController {
    @Autowired
    DeviceDaemon deviceDaemon;

    @GetMapping(value={"/devices"})
    List<FRCCanDevice> getDevices(@PathVariable String descriptor) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        DeviceTree deviceTree = this.deviceDaemon.getDeviceManager().getDeviceTree(decodedDescriptor);
        if (deviceTree == null) {
            throw new CanBusNotFoundException(descriptor);
        }
        ArrayList<FRCCanDevice> devices = new ArrayList<FRCCanDevice>(deviceTree.children());
        devices.add(deviceTree.root());
        return devices.stream().map(REVDevicesController::encodeDescriptorForDevice).toList();
    }

    public static FRCCanDevice encodeDescriptorForDevice(FRCCanDevice device) {
        return new FRCCanDevice(CanBridgeController.encodeDescriptor(device.descriptor()), device.id(), device.isInBootloader(), device.type(), device.uuid());
    }
}

