/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.devices;

import com.revrobotics.SparkAdvanced;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.device.detection.DeviceDaemon;
import com.revrobotics.device.detection.HeartbeatSender;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.revui.app.CanBridgeController;
import com.revrobotics.revui.app.annotations.EnforcesDeviceType;
import com.revrobotics.revui.app.annotations.StandardExceptions;
import com.revrobotics.revui.app.annotations.Success;
import com.revrobotics.revui.app.exceptions.ActionFailedException;
import com.revrobotics.revui.app.exceptions.DeviceNotPresentException;
import com.revrobotics.revui.app.exceptions.WrongDeviceTypeException;
import com.revrobotics.revui.app.validation.PidSlot;
import com.revrobotics.spark.ClosedLoopSlot;
import com.revrobotics.spark.SparkBase;
import com.revrobotics.spark.config.SparkParameters;
import java.util.UUID;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/bus/{descriptor}/spark/{uuid}"})
public class SparkController {
    private static final Logger logger = Logger.getLogger(SparkController.class.getName());
    @Autowired
    DeviceDaemon deviceDaemon;

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/voltage"})
    public double getVoltage(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkBase spark = this.getSpark(decodedDescriptor, uuid);
        return spark.getBusVoltage();
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/enable"})
    public void setEnabled(@PathVariable String descriptor, @PathVariable UUID uuid, boolean enable) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        CanBus bus = this.deviceDaemon.getDeviceManager().getCanBus(decodedDescriptor);
        HeartbeatSender sender = this.deviceDaemon.getDeviceManager().getHeartbeatSender();
        if (enable) {
            sender.enableSpark(bus, device.id());
        } else {
            sender.disableSpark(bus, device.id());
        }
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/setpoint"})
    public double getSetpoint(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkBase spark = this.getSpark(decodedDescriptor, uuid);
        return spark.getClosedLoopController().getSetpoint();
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/setpoint"})
    public void setSetpoint(@PathVariable String descriptor, @PathVariable UUID uuid, double setpoint, @RequestParam(defaultValue="0") @PidSlot int slot, SparkBase.ControlType controlType) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        ClosedLoopSlot controlSlot = ClosedLoopSlot.fromInt((int)slot);
        SparkBase spark = this.getSpark(decodedDescriptor, uuid);
        spark.getClosedLoopController().setSetpoint(setpoint, controlType, controlSlot);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/version"})
    public SparkFirmwareVersion getVersion(@PathVariable String descriptor, @PathVariable UUID uuid) {
        SparkBase spark;
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkAdvanced.SparkFirmwareVersion version = (SparkAdvanced.SparkFirmwareVersion)this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (arg_0, arg_1) -> SparkController.lambda$getVersion$0(spark = this.getSpark(decodedDescriptor, uuid), arg_0, arg_1));
        if (version == null) {
            throw new ActionFailedException();
        }
        return new SparkFirmwareVersion(version.major(), version.minor(), version.fix(), version.prerelease());
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/dfu/enter"})
    public void enterBootloader(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkBase spark = this.getSpark(decodedDescriptor, uuid);
        this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (canBridge, bus) -> {
            SparkAdvanced.enterDfuBootloader((CanBridge)canBridge, (CanBus)bus, (int)spark.getDeviceId());
            return null;
        });
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/identify"})
    public void identify(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkBase spark = this.getSpark(decodedDescriptor, uuid);
        this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (canBridge, bus) -> {
            SparkAdvanced.identify((CanBridge)canBridge, (CanBus)bus, (int)spark.getDeviceId());
            return null;
        });
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/faults"})
    public FaultsAndWarnings getFaults(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkBase spark = this.getSpark(decodedDescriptor, uuid);
        return new FaultsAndWarnings(spark.getFaults(), spark.getWarnings(), spark.getStickyFaults(), spark.getStickyWarnings());
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/limits"})
    public LimitSwitches getLimits(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkBase spark = this.getSpark(decodedDescriptor, uuid);
        return new LimitSwitches(spark.getForwardLimitSwitch().isPressed(), spark.getReverseLimitSwitch().isPressed(), false, false);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/faults/clear"})
    public void clearStickyFaults(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkBase spark = this.getSpark(decodedDescriptor, uuid);
        spark.clearFaults();
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/usb-check"})
    public boolean usbCheck(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        SparkBase spark = this.getSpark(decodedDescriptor, uuid);
        return (Boolean)this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (canBridge, bus) -> SparkAdvanced.checkIfUsbBridge((CanBridge)canBridge, (CanBus)bus, (int)spark.getDeviceId()));
    }

    private SparkBase getSpark(String descriptor, UUID uuid) {
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(descriptor, uuid);
        this.throwIfNeeded(device, uuid);
        SparkBase result = this.deviceDaemon.getDeviceManager().getRevLibDeviceManager().getSpark(device.id());
        if (result == null) {
            logger.severe("No SPARK with uuid " + String.valueOf(uuid) + " found");
            throw new DeviceNotPresentException(uuid);
        }
        return result;
    }

    private void throwIfNeeded(FRCCanDevice device, UUID uuid) {
        if (device == null) {
            throw new DeviceNotPresentException(uuid);
        }
        if (device.type() == null || !device.type().isSPARK()) {
            throw new WrongDeviceTypeException();
        }
    }

    private static /* synthetic */ SparkAdvanced.SparkFirmwareVersion lambda$getVersion$0(SparkBase spark, CanBridge bridge, CanBus bus) {
        return SparkAdvanced.getFirmwareVersion((CanBridge)bridge, (CanBus)bus, (int)spark.getDeviceId());
    }

    public record SparkFirmwareVersion(int major, int minor, int fix, int prerelease) {
    }

    public record FaultsAndWarnings(SparkBase.Faults faults, SparkBase.Warnings warnings, SparkBase.Faults stickyFaults, SparkBase.Warnings stickyWarnings) {
    }

    public record LimitSwitches(boolean forwardHardLimit, boolean reverseHardLimit, boolean forwardSoftLimit, boolean reverseSoftLimit) {
    }

    public record ParameterInfo(String name, int id, SparkParameters.Type type) {
    }
}

